function [fitresult, gof] = createSurfaceFit(AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10, LacZ_output_pED_IPTG_INS_log10)
%CREATESURFACEFIT(AHL_INPUT_PED_IPTG_INS_LOG10,IPTG_INPUT_PED_IPTG_INS_LOG10,LACZ_OUTPUT_PED_IPTG_INS_LOG10)
%  Fit surface to data.
%
%  Data for 'untitled fit 1' fit:
%      X Input : AHL_input_pED_IPTG_INS_log10
%      Y Input : IPTG_input_pED_IPTG_INS_log10
%      Z output: LacZ_output_pED_IPTG_INS_log10
%      Weights : (none)
%
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.

%  Auto-generated by MATLAB on 04-Apr-2011 16:30:19


%% Fit: 'untitled fit 1'.
ft = fittype( '(bottom1 + (top1 - bottom1) / (1+10^(LogEC50_1 - x))) * (bottom2 + (top2 - bottom2) / (1+10^(LogEC50_2 - y)))', 'indep', {'x', 'y'}, 'depend', 'z' );
opts = fitoptions( ft );
opts.Display = 'Off';
opts.Lower = [-Inf -Inf -Inf -Inf -Inf -Inf];
opts.StartPoint = [0.345565927376724 0.511142979027213 0.527232849483832 0.521533398083447 0.284479172477811 0.951406258730611];
opts.Upper = [Inf Inf Inf Inf Inf Inf];
opts.Weights = zeros(1,0);
[fitresult, gof] = fit( [AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10], LacZ_output_pED_IPTG_INS_log10, ft, opts );

% Plot fit with data.
figure( 'Name', 'untitled fit 1' );
h = plot( fitresult, [AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10], LacZ_output_pED_IPTG_INS_log10 );
grid on
% Label axes
xlabel( 'AHL_input_pED_IPTG_INS_log10' );
ylabel( 'IPTG_input_pED_IPTG_INS_log10' );
zlabel( 'LacZ_output_pED_IPTG_INS_log10' );
legend( h, 'untitled fit 1', 'LacZ_output_pED_IPTG_INS_log10 vs. AHL_input_pED_IPTG_INS_log10, IPTG_input_pED_IPTG_INS_log10', 'Location', 'NorthEast' );
view( -57.5, 80 );


